#
# Ident512: Implements an identification routine for the groups of order 512.
#
# This file contains package meta data. For additional information on
# the meaning and correct usage of these fields, please consult the
# manual of the "Example" package as well as the comments in its
# PackageInfo.g file.
#
SetPackageInfo( rec(

PackageName := "Ident512",
Subtitle := "An identification routine for the groups of order 512",
Version := "0.8",
Date := "03/12/2025", # dd/mm/yyyy format
License := "GPL-2.0-or-later",

Persons := [
  rec(
    FirstNames := "Henrik",
    LastName := "Schanze",
    WWWHome := "https://www.iaa.tu-bs.de/henschan",
    Email := "henrik.schanze@tu-braunschweig.de",
    IsAuthor := true,
    IsMaintainer := true,
    PostalAddress := "Universitaetsplatz 2",
    Place := "Braunschweig, Germany",
    Institution := "TU Braunschweig",
  ),
],

#SourceRepository := rec( Type := "TODO", URL := "URL" ),
#IssueTrackerURL := "TODO",
PackageWWWHome := "https://TODO/",
PackageInfoURL := Concatenation( ~.PackageWWWHome, "PackageInfo.g" ),
README_URL     := Concatenation( ~.PackageWWWHome, "README.md" ),
ArchiveURL     := Concatenation( ~.PackageWWWHome,
                                 "/", ~.PackageName, "-", ~.Version ),

ArchiveFormats := ".tar.gz",

AbstractHTML   :=  "",

PackageDoc := rec(
  BookName  := "Ident512",
  ArchiveURLSubset := ["doc"],
  HTMLStart := "doc/chap0_mj.html",
  PDFFile   := "doc/manual.pdf",
  SixFile   := "doc/manual.six",
  LongTitle := "An identification routine for the groups of order 512.",
),

Dependencies := rec(
  GAP := ">= 4.13",
  NeededOtherPackages := [["smallgrp","1.5.3"],["anupq", "3.3.1"]],
  SuggestedOtherPackages := [["modisom","2.5.4"], ["xmod", "2.92"]],
  ExternalConditions := [ ],
),

AvailabilityTest := ReturnTrue,

TestFile := "tst/testall.g",

#Keywords := [ "TODO" ],

));


